<?php
if( ! class_exists( 'WordPressUser' ) ) {
class WordPressUser  extends XoopsTableObject
{
	/**
	 * 󥹥ȥ饯
	 */
	function WordPressUser() {
	////////////////////////////////////////
	// ƥ饹ʬ()
	////////////////////////////////////////
		
		//ƥ饹Υ󥹥ȥ饯ƽ
		$this->XoopsTableObject();

	////////////////////////////////////////
	// 饹ͭʬ
	////////////////////////////////////////

		//ƥ֥Ǥ
		$this->initVar('ID', XOBJ_DTYPE_INT, NULL, true);
		$this->initVar('user_login', XOBJ_DTYPE_TXTBOX, NULL, true, 20);
		$this->initVar('user_pass', XOBJ_DTYPE_TXTBOX, NULL, false,20);
		$this->initVar('user_firstname', XOBJ_DTYPE_TXTBOX, NULL, false,50);
		$this->initVar('user_lastname', XOBJ_DTYPE_TXTBOX, NULL, false,50);
		$this->initVar('user_nickname', XOBJ_DTYPE_TXTBOX, NULL, false,50);
		$this->initVar('user_icq', XOBJ_DTYPE_INT, NULL, false);
		$this->initVar('user_email', XOBJ_DTYPE_EMAIL, NULL, false,100);
		$this->initVar('user_url', XOBJ_DTYPE_URL, NULL, false,100);
		$this->initVar('user_ip', XOBJ_DTYPE_TXTBOX, NULL, false,15);
		$this->initVar('user_domain', XOBJ_DTYPE_TXTBOX, NULL, false,200);
		$this->initVar('user_browser', XOBJ_DTYPE_TXTBOX, NULL, false,200);
		$this->initVar('dateYMDhour', XOBJ_DTYPE_TXTBOX, NULL, false,50);
		$this->initVar('user_level', XOBJ_DTYPE_INT, NULL, false);
		$this->initVar('user_aim', XOBJ_DTYPE_TXTBOX, NULL, false,50);
		$this->initVar('user_msn', XOBJ_DTYPE_TXTBOX, NULL, false,100);
		$this->initVar('user_yim', XOBJ_DTYPE_TXTBOX, NULL, false,50);
		$this->initVar('user_idmode', XOBJ_DTYPE_TXTBOX, NULL, false,20);
		$this->initVar('user_description', XOBJ_DTYPE_TXTAREA, NULL, false);

		//ץ饤ޥ꡼
		$this->setKeyFields(array('ID'));
	}
	
	// ƥ֥Ǥθڥ᥽å
	// - CleanVars᥽åɤƤФ줿Ȥˡ
	//   checkVar_̾ Ȥ᥽åɤƤиƤФޤ
	function checkVar_user_email(&$value) {
		if ($value) {
			//᡼Υåϴ˹ԤäƤ뤬åȽ䤹
			if (!checkEmail($value)) {
				$this->setErrors(_LANG_WPF_ERR_CORRECT);
                return false;
			}
		}
	}
	function checkVar_user_icq(&$value) {
		if ($value) {
			//ICQ IDϤ٤ƿ
			if ((ereg("^[0-9]+$",$value))==false) {
				$this->setErrors(_LANG_WPF_ERR_ICQUIN);
                return false;
			}
		}
	}

	// ¾Υ桼ƥƥåå
	function get_uniqname($format = 's') {
		switch($this->getVar('user_idmode')) {
			case 'nickname':	return($this->getVar('user_nickname',$format));	break;
			case 'login':		return($this->getVar('user_login',$format));		break;
			case 'firstname':	return($this->getVar('user_firstname',$format));	break;
			case 'lastname':	return($this->getVar('user_lastname',$format));	break;
			case 'namefl':		return($this->getVar('user_firstname',$format).' '.$this->getVar('user_lastname',$format));	break;
	 		case 'namelf':		return($this->getVar('user_lastname',$format).' '.$this->getVar('user_firstname',$format));	break;
	 		default:			return($this->getVar('user_nickname',$format));	break;
		}
	}

	function getNumPosts() {
		$criteria =& new CriteriaCompo(new Criteria('post_author', $this->getVar('ID')));
		$criteria->add(new Criteria('post_status', 'publish'));
		$postHandler =& new WordPressPostHandler($this->_handler->db, $this->_handler->prefix, $this->_handler->module);
		return $postHandler->getCount($criteria);
	}

	function getPostIDs($status='') {
		$criteria =& new CriteriaCompo(new Criteria('post_author', $this->getVar('ID')));
		if ($status) {
			$criteria->add(new Criteria('post_status', $status));
		}
		$postHandler =& new WordPressPostHandler($this->_handler->db, $this->_handler->prefix, $this->_handler->module);
		$posts =& $postHandler->getObjects($criteria);
		$IDs = array();
		foreach($posts as $post) {
			$IDs[] = $post->getVar('ID');
		}
		return $IDs;
	}

	function upUserLevel() {
		if ($this->getVar('user_level') < 10) {
	        return $this->_handler->updateByField($this, 'user_level', $this->getVar('user_level') + 1);
        } else {
        	return false;
        }
	}

	function downUserLevel() {
		if ($this->getVar('user_level') > 0) {
        	return $this->_handler->updateByField($this, 'user_level', $this->getVar('user_level') - 1);
        } else {
        	return false;
        }
	}
}

class WordPressUserHandler  extends XoopsTableObjectHandler
{
	var $prefix;
	var $module;
	/**
	 * 󥹥ȥ饯
	 */
	function WordPressUserHandler($db,$prefix,$module)
	{
	////////////////////////////////////////
	// ƥ饹ʬ()
	////////////////////////////////////////

		//ƥ饹Υ󥹥ȥ饯ƽ
		$this->XoopsTableObjectHandler($db);
		
	////////////////////////////////////////
	// 饹ͭʬ
	////////////////////////////////////////
		//ϥɥоݥơ֥̾
		$this->prefix = $prefix;
		$this->module = $module;
		$this->tableName = $this->db->prefix($prefix.'users');
		if (empty($GLOBALS['__'.$prefix.'usersync'])) {
			$this->syncXoopsUsers();
			$GLOBALS['__'.$prefix.'usersync'] = true;
		}
	}
	
	/**
     * 쥳ɤμ(ץ饤ޥ꡼ˤո
     * 
     * @param	string $key 
	 *
     * @return	object  {@link WordPressUser}, FALSE on fail
     */
	function &get($key, $sync_xoops=true)
	{
		if ($userObject =& parent::get($key)) {
			$member_handler =& xoops_gethandler('member');
			$member =& $member_handler->getUser($userObject->getVar('ID'));
            if ($member) {
                $userObject->assignVar('user_pass', $member->getVar('pass'));
            }
			return $userObject;
		} else {
			if ($sync_xoops) {
				$member_handler =& xoops_gethandler('member');
				$member =& $member_handler->getUser($key);
				if ($member) {
					$userObject =& $this->create();
					$userObject->setVar('ID', $key);
					if ($this->insert($userObject,true)) {
						$userObject =& parent::get($key);
						$userObject->assignVar('user_pass', $member->getVar('pass'));
						return $userObject;
					} else {
						return false;
					}
				} else {
					return false;
				}
			} else {
				return false;
			}
		}
	}
	/**
     * 쥳ɤμ(̾ˤ븡
     * 
     * @param	string $login 
	 *
     * @return	object  {@link WordPressUser}, FALSE on fail
     */
	function &getByLogin($login, $sync_xoops=true)
	{
		$criteria =& new Criteria('user_login', $login);
		$userObjects =& $this->getObjects($criteria);
		if (count($userObjects) == 1) {
			$userObject =& $userObjects[0];
			$member_handler =& xoops_gethandler('member');
			$member =& $member_handler->getUser($userObject->getVar('ID'));
			$userObject->assignVar('user_pass', $member->getVar('pass'));
			return $userObject;
		} else {
			if ($sync_xoops) {
				$member_handler =& xoops_gethandler('member');
				$criteria =& new Criteria('uname', $login);
				$members =& $member_handler->getUsers($criteria);
				if (count($members)) {
					$member = $members[0];
					$userObject =& $this->create();
					$userObject->setVar('ID', $key);
					if ($this->insert($userObject,true)) {
						$userObject =& parent::get($key);
						$userObject->assignVar('user_pass', $member->getVar('pass'));
						return $userObject;
					} else {
						return false;
					}
				} else {
					return false;
				}
			} else {
				return false;
			}
		}
	}
    /**
     * 쥳ɤ¸
     * 
     * @param	object	&$record	{@link WordPressUser} object
     * @param	bool	$force		POST᥽åɰʳǶture
     * 
     * @return	bool    λ TRUE
     */
	function insert(&$record, $force=false, $updateOnlyChanged=false)
	{
		$member_handler =& xoops_gethandler('member');
		$member =& $member_handler->getUser($record->getVar('ID'));
		if ($record->isNew()) {
			$user_level = 0;
			$group = $member->getGroups();
			$edit_groups = get_xoops_option($this->module, 'wp_edit_authgrp');
			$admin_groups = get_xoops_option($this->module, 'wp_admin_authgrp');
			if (count(array_intersect($group,$edit_groups)) > 0) {
				$user_level = 1;
			}
			if (count(array_intersect($group,$admin_groups)) > 0) {
				$user_level = 10;
			}
			$record->setVar('user_login', $member->getVar('uname'));
			$record->setVar('user_nickname', $member->getVar('uname'));
			$record->setVar('user_email', $member->getVar('email'));
			$record->setVar('user_url', $member->getVar('url'));
			$record->setVar('user_level', $user_level);
			$record->setVar('user_icq', intval($member->getVar('user_icq')));
			$record->setVar('user_aim', $member->getVar('user_aim'));
			$record->setVar('user_yim', $member->getVar('user_yim'));
			$record->setVar('user_msn', $member->getVar('user_msnm'));
			$record->setVar('user_idmode', 'nickname');
		} else {
			if ($member->getVar('uname') != $record->getVar('user_login')) {
				$record->setVar('user_login', $member->getVar('uname'));
			}
			if (trim($record->getVar('user_nickname')) == '') {
				$record->setVar('user_nickname', $member->getVar('uname'));
			}
		}
		return parent::insert($record,$force,$updateOnlyChanged);
	}
	/**
	 * 쥳ɤκ
	 * 
     * @param	object  &$record  {@link WordPressUser} object
     * @param	bool	$force		POST᥽åɰʳǶture
     * 
     * @return	bool    λ TRUE
	 */
	function delete(&$record,$force=false)
	{
		//桼κ
		if (!(parent::delete($record,$force))) {
			return false;
		}
		//桼ƤڤӴϢκ
		$criteria =& new Criteria('post_author', $record->getVar('ID'));
		$post_handler =& new WordPressPostHandler($this->db, $this->prefix, $this->module);
		if (!($post_handler->deleteAll($criteria))) {
			return false;
		}
		//桼󥯾κ
		$criteria =& new Criteria('link_owner', $record->getVar('ID'));
		$link_handler =& new WordPressLinkHandler($this->db, $this->prefix, $this->module);
		if (!($link_handler->deleteAll($criteria))) {
			return false;
		}

	    return true;
	}
	/**
	 * ơ֥ξ︡ˤʣ쥳ɼ
	 * 
	 * @param	object	$criteria 	{@link CriteriaElement} 
	 * @param	bool $id_as_key		ץ饤ޥ꡼Υˤtrue
	 * @return	mixed Array			̥쥳ɤ
	 */
/*ơ֥˸ͭΥǡɬפʻʳ
	function &getObjects($criteria = null, $id_as_key = false, $fieldlist="")
	{
		return parent::getObjects($criteria, $id_as_key, $fieldlist);
	}
*/
	/**
	 * 󥯥ƥꥹ
	 * 
	 * @return	mixed Array			
	 */
	function getOptionArray()
	{
		$optionArray=array();
		
		$criteria =& new CriteriaElement();
		$criteria->setSort('ID');
		$users =& $this->getObjects($criteria);
		if ($users) {
			foreach ($users as $user) {
				$ID = $user->getVar('ID');
				$user_login =  $user->getVar('user_login');
				$optionArray["$ID"] = "$user_login";
			}
		}
		return $optionArray;
	}
	function syncXoopsUsers()
	{
		$member_handler =& xoops_gethandler('member');
		$members =& $member_handler->getUsers();
		$this->getObjects();
		foreach($members as $member) {
			$this->get($member->getVar('uid'));
		}
	}
}
}
?>